/*
 * Decompiled with CFR 0.152.
 */
package libsidutils.stringsearch;

import libsidutils.stringsearch.CharIntMap;

abstract class StringSearch {
    StringSearch() {
    }

    public abstract Object processBytes(byte[] var1);

    public abstract Object processChars(char[] var1);

    public final int searchBytes(byte[] text, byte[] pattern) {
        return this.searchBytes(text, 0, text.length, pattern, this.processBytes(pattern));
    }

    public final int searchBytes(byte[] text, byte[] pattern, Object processed) {
        return this.searchBytes(text, 0, text.length, pattern, processed);
    }

    public final int searchBytes(byte[] text, int textStart, byte[] pattern) {
        return this.searchBytes(text, textStart, text.length, pattern, this.processBytes(pattern));
    }

    public final int searchBytes(byte[] text, int textStart, byte[] pattern, Object processed) {
        return this.searchBytes(text, textStart, text.length, pattern, processed);
    }

    public final int searchBytes(byte[] text, int textStart, int textEnd, byte[] pattern) {
        return this.searchBytes(text, textStart, textEnd, pattern, this.processBytes(pattern));
    }

    public abstract int searchBytes(byte[] var1, int var2, int var3, byte[] var4, Object var5);

    public final int searchChars(char[] text, char[] pattern) {
        return this.searchChars(text, 0, text.length, pattern, this.processChars(pattern));
    }

    public final int searchChars(char[] text, char[] pattern, Object processed) {
        return this.searchChars(text, 0, text.length, pattern, processed);
    }

    public final int searchChars(char[] text, int textStart, char[] pattern) {
        return this.searchChars(text, textStart, text.length, pattern, this.processChars(pattern));
    }

    public final int searchChars(char[] text, int textStart, char[] pattern, Object processed) {
        return this.searchChars(text, textStart, text.length, pattern, processed);
    }

    public final int searchChars(char[] text, int textStart, int textEnd, char[] pattern) {
        return this.searchChars(text, textStart, textEnd, pattern, this.processChars(pattern));
    }

    public abstract int searchChars(char[] var1, int var2, int var3, char[] var4, Object var5);

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return this.getClass().equals(obj.getClass());
    }

    public final int hashCode() {
        return this.getClass().getName().hashCode();
    }

    public final String toString() {
        return this.toStringBuffer(null).toString();
    }

    public StringBuffer toStringBuffer(StringBuffer in) {
        if (in == null) {
            in = new StringBuffer();
        }
        in.append("{ ");
        int idx = this.getClass().getName().lastIndexOf(".");
        if (idx > -1) {
            in.append(this.getClass().getName().substring(++idx));
        } else {
            in.append(this.getClass().getName());
        }
        in.append(" }");
        return in;
    }

    protected CharIntMap createCharIntMap(char[] pattern) {
        return this.createCharIntMap(pattern, 0);
    }

    protected CharIntMap createCharIntMap(char[] pattern, int defaultValue) {
        char min = '\uffff';
        char max = '\u0000';
        for (char element : pattern) {
            max = max > element ? max : element;
            min = min < element ? min : element;
        }
        return new CharIntMap(max - min + 1, min, defaultValue);
    }

    protected final int index(byte idx) {
        return idx < 0 ? 256 + idx : idx;
    }
}

